<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

	  const Err1 = "Security error: Call to private object member not allowed";
	  const Err2 = "Security error: Call to dynamic object member not allowed";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;

    function __construct($lex, $compiler) {
        // set instance object
        self::instance($this); 
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
				$this->compiler->prefix_code = array();
				$this->prefix_number = 0;
				$this->block_nesting_level = 0;
				if ($this->security = isset($this->smarty->security_policy)) {
              $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
              $this->php_handling = $this->smarty->php_handling;
        }
				$this->is_xml = false;
				$this->asp_tags = (ini_get('asp_tags') != '0');
				$this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }
    public static function &instance($new_instance = null)
    {
        static $instance = null;
        if (isset($new_instance) && is_object($new_instance))
            $instance = $new_instance;
        return $instance;
    }

    public static function escape_start_tag($tag_text) {
       $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
       assert($tag !== false && $count === 1);
       return $tag;
    }

    public static function escape_end_tag($tag_text) {
       assert($tag_text === '?>');
       return '?<?php ?>>';
    }

    
#line 132 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_OTHER                          = 10;
    const TP_LINEBREAK                      = 11;
    const TP_LITERALSTART                   = 12;
    const TP_LITERALEND                     = 13;
    const TP_LITERAL                        = 14;
    const TP_LDEL                           = 15;
    const TP_RDEL                           = 16;
    const TP_DOLLAR                         = 17;
    const TP_ID                             = 18;
    const TP_EQUAL                          = 19;
    const TP_PTR                            = 20;
    const TP_LDELIF                         = 21;
    const TP_SPACE                          = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_AS                             = 29;
    const TP_APTR                           = 30;
    const TP_SMARTYBLOCKCHILD               = 31;
    const TP_LDELSLASH                      = 32;
    const TP_INTEGER                        = 33;
    const TP_COMMA                          = 34;
    const TP_MATH                           = 35;
    const TP_UNIMATH                        = 36;
    const TP_ANDSYM                         = 37;
    const TP_ISIN                           = 38;
    const TP_ISDIVBY                        = 39;
    const TP_ISNOTDIVBY                     = 40;
    const TP_ISEVEN                         = 41;
    const TP_ISNOTEVEN                      = 42;
    const TP_ISEVENBY                       = 43;
    const TP_ISNOTEVENBY                    = 44;
    const TP_ISODD                          = 45;
    const TP_ISNOTODD                       = 46;
    const TP_ISODDBY                        = 47;
    const TP_ISNOTODDBY                     = 48;
    const TP_INSTANCEOF                     = 49;
    const TP_OPENP                          = 50;
    const TP_CLOSEP                         = 51;
    const TP_QMARK                          = 52;
    const TP_NOT                            = 53;
    const TP_TYPECAST                       = 54;
    const TP_HEX                            = 55;
    const TP_DOT                            = 56;
    const TP_SINGLEQUOTESTRING              = 57;
    const TP_DOUBLECOLON                    = 58;
    const TP_AT                             = 59;
    const TP_HATCH                          = 60;
    const TP_OPENB                          = 61;
    const TP_CLOSEB                         = 62;
    const TP_EQUALS                         = 63;
    const TP_NOTEQUALS                      = 64;
    const TP_GREATERTHAN                    = 65;
    const TP_LESSTHAN                       = 66;
    const TP_GREATEREQUAL                   = 67;
    const TP_LESSEQUAL                      = 68;
    const TP_IDENTITY                       = 69;
    const TP_NONEIDENTITY                   = 70;
    const TP_MOD                            = 71;
    const TP_LAND                           = 72;
    const TP_LOR                            = 73;
    const TP_LXOR                           = 74;
    const TP_QUOTE                          = 75;
    const TP_BACKTICK                       = 76;
    const TP_DOLLARID                       = 77;
    const YY_NO_ACTION = 573;
    const YY_ACCEPT_ACTION = 572;
    const YY_ERROR_ACTION = 571;

    const YY_SZ_ACTTAB = 2401;
static public $yy_action = array(
 /*     0 */   191,  304,  303,  306,  305,  307,  302,  301,  297,  296,
 /*    10 */   298,  299,  300,  168,  334,  325,   37,  341,  152,    3,
 /*    20 */    38,   38,  215,  281,  201,  218,  360,  128,  277,  133,
 /*    30 */    33,  243,  270,  209,   50,   44,   49,   43,   13,    9,
 /*    40 */   354,  361,   19,   35,  362,  370,   30,   20,  320,  315,
 /*    50 */   311,  310,  316,  103,  265,  279,  168,  309,  319,  356,
 /*    60 */   191,   38,  371,  372,  373,  369,  368,  364,  363,  365,
 /*    70 */   366,  367,  349,  268,  191,  269,  331,  170,   25,  219,
 /*    80 */   202,   38,  213,   52,  252,  116,  115,  176,  440,  324,
 /*    90 */    17,   14,  284,  348,  440,   38,  359,  352,    3,  330,
 /*   100 */   226,  572,   91,  239,  303,  306,  128,  169,   50,   44,
 /*   110 */    49,   43,   13,    9,  354,  361,   19,   35,  362,  370,
 /*   120 */    30,   20,    3,  272,    7,  146,  437,  204,  102,   38,
 /*   130 */   128,   10,  437,  112,  322,  277,  371,  372,  373,  369,
 /*   140 */   368,  364,  363,  365,  366,  367,  349,  268,  191,  357,
 /*   150 */   331,  179,  238,  142,  202,  275,  213,   61,   18,  116,
 /*   160 */     3,  274,   41,  295,   24,  135,  284,  348,  128,   38,
 /*   170 */   359,  352,   18,  330,   18,  274,   41,  274,  233,  192,
 /*   180 */   232,   38,   50,   44,   49,   43,   13,    9,  354,  361,
 /*   190 */    19,   35,  362,  370,   30,   20,   18,  283,   18,  274,
 /*   200 */    15,  274,  228,  119,  185,   18,  236,  155,  274,    8,
 /*   210 */   371,  372,  373,  369,  368,  364,  363,  365,  366,  367,
 /*   220 */   349,  268,  191,  167,  331,  281,  148,  173,  202,  101,
 /*   230 */   213,   61,   21,  116,  120,  158,  277,   12,   11,  135,
 /*   240 */   284,  348,  228,   38,  359,  352,  159,  330,   39,  230,
 /*   250 */   179,   40,  179,   27,  200,  260,   50,   44,   49,   43,
 /*   260 */    13,    9,  354,  361,   19,   35,  362,  370,   30,   20,
 /*   270 */     3,  144,   48,  442,  100,  185,  339,  312,  128,  442,
 /*   280 */     8,  277,  191,   38,  371,  372,  373,  369,  368,  364,
 /*   290 */   363,  365,  366,  367,  349,  268,  191,  179,  331,  259,
 /*   300 */    94,  147,  202,   38,  213,   61,   48,  116,  229,   18,
 /*   310 */    48,  277,  274,  321,  284,  348,   38,   38,  359,  352,
 /*   320 */   313,  330,  275,  439,  206,   23,   38,  285,  257,  439,
 /*   330 */    50,   44,   49,   43,   13,    9,  354,  361,   19,   35,
 /*   340 */   362,  370,   30,   20,  287,  436,  286,  141,  175,  335,
 /*   350 */   267,   38,  114,  231,  281,    2,   48,  277,  371,  372,
 /*   360 */   373,  369,  368,  364,  363,  365,  366,  367,  349,  268,
 /*   370 */   191,  331,  164,  177,  150,  202,  174,  213,   61,  162,
 /*   380 */   116,  191,  277,   18,  277,  180,  274,  284,  348,  277,
 /*   390 */    38,  359,  352,  275,  330,   96,  436,  271,  210,   38,
 /*   400 */   275,  223,   38,   38,   50,   44,   49,   43,   13,    9,
 /*   410 */   354,  361,   19,   35,  362,  370,   30,   20,  345,  278,
 /*   420 */   151,  327,  220,   18,   38,   38,  274,   38,  166,  335,
 /*   430 */   277,  126,  371,  372,  373,  369,  368,  364,  363,  365,
 /*   440 */   366,  367,  349,  268,  191,  331,  177,  222,  143,  202,
 /*   450 */   131,  197,   68,  121,  116,  224,  203,  276,  277,  178,
 /*   460 */   135,  284,  348,   38,  330,  359,  352,  346,  330,  275,
 /*   470 */   227,  347,   18,   38,  318,  208,  317,   38,   50,   44,
 /*   480 */    49,   43,   13,    9,  354,  361,   19,   35,  362,  370,
 /*   490 */    30,   20,  191,  153,  149,  294,  329,   18,  119,  240,
 /*   500 */   225,   38,   38,  277,  277,   38,  371,  372,  373,  369,
 /*   510 */   368,  364,  363,  365,  366,  367,  349,  268,  326,  177,
 /*   520 */   177,  156,   18,  275,   38,  207,   50,   44,   49,   43,
 /*   530 */    13,    9,  354,  361,   19,   35,  362,  370,   30,   20,
 /*   540 */    99,  280,  247,  248,  336,  266,  323,   38,    6,   38,
 /*   550 */    38,   38,  117,  321,  371,  372,  373,  369,  368,  364,
 /*   560 */   363,  365,  366,  367,  349,  268,  191,  331,  172,  335,
 /*   570 */   353,  202,  256,  213,   74,  160,  116,  130,   38,   48,
 /*   580 */   333,  254,   28,  284,  348,  277,   38,  359,  352,  258,
 /*   590 */   330,  328,  255,  281,    4,   38,   18,   38,   38,  196,
 /*   600 */    50,   44,   49,   43,   13,    9,  354,  361,   19,   35,
 /*   610 */   362,  370,   30,   20,  191,  288,   89,    2,  127,  234,
 /*   620 */    48,  293,  130,  264,  289,  341,  204,   93,  371,  372,
 /*   630 */   373,  369,  368,  364,  363,  365,  366,  367,  349,  268,
 /*   640 */   321,  253,  229,  118,   34,  134,   90,    5,   50,   44,
 /*   650 */    49,   43,   13,    9,  354,  361,   19,   35,  362,  370,
 /*   660 */    30,   20,  338,  157,  165,  161,  314,  286,  135,   16,
 /*   670 */   275,  332,   42,  123,  277,  277,  371,  372,  373,  369,
 /*   680 */   368,  364,  363,  365,  366,  367,  349,  268,  191,  331,
 /*   690 */   263,  122,   95,  202,  108,  213,   72,  214,  116,  242,
 /*   700 */   136,  108,  245,  106,  321,  284,  348,  321,  132,  359,
 /*   710 */   352,  171,  330,  321,  321,  273,  321,  177,  191,  104,
 /*   720 */   275,   29,   50,   44,   49,   43,   13,    9,  354,  361,
 /*   730 */    19,   35,  362,  370,   30,   20,  105,  308,  318,  318,
 /*   740 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  321,
 /*   750 */   371,  372,  373,  369,  368,  364,  363,  365,  366,  367,
 /*   760 */   349,  268,  191,  331,  318,  318,  318,  202,  318,  213,
 /*   770 */    55,  318,  116,  318,  137,   97,  318,  261,  318,  284,
 /*   780 */   348,  318,  318,  359,  352,  318,  330,  321,  321,  318,
 /*   790 */   318,  318,  318,  318,  318,  318,   50,   44,   49,   43,
 /*   800 */    13,    9,  354,  361,   19,   35,  362,  370,   30,   20,
 /*   810 */   191,   31,  318,  318,  318,  318,  318,  318,  318,  318,
 /*   820 */   318,  318,  318,  318,  371,  372,  373,  369,  368,  364,
 /*   830 */   363,  365,  366,  367,  349,  268,  318,  318,  318,  318,
 /*   840 */   318,  318,  318,  318,   50,   44,   49,   43,   13,    9,
 /*   850 */   354,  361,   19,   35,  362,  370,   30,   20,  191,  318,
 /*   860 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*   870 */   318,  318,  371,  372,  373,  369,  368,  364,  363,  365,
 /*   880 */   366,  367,  349,  268,  318,  318,  318,  318,  318,  318,
 /*   890 */   318,  318,   50,   44,   49,   43,   13,    9,  354,  361,
 /*   900 */    19,   35,  362,  370,   30,   20,  191,  318,  221,  318,
 /*   910 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*   920 */   371,  372,  373,  369,  368,  364,  363,  365,  366,  367,
 /*   930 */   349,  268,  318,  318,  217,  318,  318,  318,  318,  318,
 /*   940 */    50,   44,   49,   43,   13,    9,  354,  361,   19,   35,
 /*   950 */   362,  370,   30,   20,  191,  318,  318,  318,  318,  318,
 /*   960 */   318,  318,  318,  318,  318,  318,  318,  318,  371,  372,
 /*   970 */   373,  369,  368,  364,  363,  365,  366,  367,  349,  268,
 /*   980 */   318,  318,  318,  318,  318,  318,  318,  318,   50,   44,
 /*   990 */    49,   43,   13,    9,  354,  361,   19,   35,  362,  370,
 /*  1000 */    30,   20,  191,  318,  318,  318,  318,  318,  318,  318,
 /*  1010 */   318,  318,  318,  318,  318,  246,  371,  372,  373,  369,
 /*  1020 */   368,  364,  363,  365,  366,  367,  349,  268,  318,  318,
 /*  1030 */   318,  318,  318,  318,  318,  318,   50,   44,   49,   43,
 /*  1040 */    13,    9,  354,  361,   19,   35,  362,  370,   30,   20,
 /*  1050 */   191,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  1060 */   318,  318,  318,  318,  371,  372,  373,  369,  368,  364,
 /*  1070 */   363,  365,  366,  367,  349,  268,  318,  337,  318,  318,
 /*  1080 */   318,  318,  318,  318,   50,   44,   49,   43,   13,    9,
 /*  1090 */   354,  361,   19,   35,  362,  370,   30,   20,  318,  318,
 /*  1100 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  1110 */   318,  318,  371,  372,  373,  369,  368,  364,  363,  365,
 /*  1120 */   366,  367,  349,  268,   50,   44,   49,   43,   13,    9,
 /*  1130 */   354,  361,   19,   35,  362,  370,   30,   20,  318,  318,
 /*  1140 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  1150 */   318,  318,  371,  372,  373,  369,  368,  364,  363,  365,
 /*  1160 */   366,  367,  349,  268,  318,  318,  318,  318,   37,  318,
 /*  1170 */   129,  186,  318,  331,  215,  318,  201,  351,  318,  213,
 /*  1180 */   318,  133,  116,  318,  270,  209,  216,  318,  318,   45,
 /*  1190 */   355,  442,  318,  359,  352,  318,  330,  442,  318,  318,
 /*  1200 */   318,  318,  318,   32,  212,  318,   46,   47,  292,  205,
 /*  1210 */   350,  318,  318,   96,    1,  241,  318,  318,  318,   37,
 /*  1220 */   318,  129,  193,  318,   48,  215,  318,  201,   92,  318,
 /*  1230 */   318,  318,  133,  318,  318,  270,  209,  216,  318,  318,
 /*  1240 */    45,  318,  318,  318,  318,  318,  331,  318,  318,  318,
 /*  1250 */   195,  318,  213,   73,   32,  116,  318,   46,   47,  292,
 /*  1260 */   205,  350,  284,  348,   96,    1,  359,  352,  318,  330,
 /*  1270 */    37,  318,  114,  193,  318,  318,  215,  318,  201,   92,
 /*  1280 */   194,  235,  318,  133,  318,  318,  270,  209,  216,  318,
 /*  1290 */   318,   45,  318,  318,  318,  318,  318,  331,  318,  318,
 /*  1300 */   318,  195,  318,  213,   73,   36,  116,  318,   46,   47,
 /*  1310 */   292,  205,  350,  284,  348,   96,    1,  359,  352,  318,
 /*  1320 */   330,   37,  318,  129,  189,  318,  318,  215,  318,  201,
 /*  1330 */    92,  318,  244,  318,  133,  318,  318,  270,  209,  216,
 /*  1340 */   318,  318,   45,  318,  318,  318,  318,  318,  331,  318,
 /*  1350 */   318,  318,  202,  318,  213,   66,   32,  116,  318,   46,
 /*  1360 */    47,  292,  205,  350,  284,  348,   96,    1,  359,  352,
 /*  1370 */   318,  330,   37,  318,  129,  181,  318,  318,  215,  318,
 /*  1380 */   201,   92,  318,  318,  318,  133,  318,  318,  270,  209,
 /*  1390 */   216,  318,  318,   45,  318,  318,  318,  318,  318,  331,
 /*  1400 */   318,  318,  318,  202,  318,  213,   77,   32,  116,  318,
 /*  1410 */    46,   47,  292,  205,  350,  284,  348,   96,    1,  359,
 /*  1420 */   352,  318,  330,   37,  318,  129,  182,  318,  318,  215,
 /*  1430 */   318,  201,   92,  318,  318,  318,  133,  318,  318,  270,
 /*  1440 */   209,  198,  318,  318,   45,  318,  318,  318,  318,  318,
 /*  1450 */   331,  318,  318,  318,  187,  318,  213,   83,   32,  116,
 /*  1460 */   318,   46,   47,  292,  205,  350,  284,  348,   96,    1,
 /*  1470 */   359,  352,  318,  330,   37,  318,  113,  193,  318,  318,
 /*  1480 */   215,  318,  201,   92,  318,  318,  318,  133,  318,  318,
 /*  1490 */   270,  209,  216,  318,  318,   45,  318,  318,  318,  318,
 /*  1500 */   318,  331,  318,  318,  318,  202,  318,  213,   71,   32,
 /*  1510 */   116,  318,   46,   47,  292,  205,  350,  284,  348,   96,
 /*  1520 */     1,  359,  352,  318,  330,   37,  318,  124,   88,  318,
 /*  1530 */   318,  215,  318,  201,   92,  318,  318,  318,  133,  318,
 /*  1540 */   318,  270,  209,  216,  318,  318,   45,  318,  318,  318,
 /*  1550 */   318,  318,  331,  318,  318,  318,  202,  318,  213,   81,
 /*  1560 */    32,  116,  318,   46,   47,  292,  205,  350,  284,  348,
 /*  1570 */    96,    1,  359,  352,  318,  330,   37,  318,  129,  183,
 /*  1580 */   318,  318,  215,  318,  201,   92,  318,  318,  318,  133,
 /*  1590 */   318,  318,  270,  209,  216,  318,  318,   45,  318,  318,
 /*  1600 */   318,  318,  318,  331,  318,  318,  318,  202,  318,  213,
 /*  1610 */    58,   32,  116,  318,   46,   47,  292,  205,  350,  284,
 /*  1620 */   348,   96,    1,  359,  352,  318,  330,   37,  318,  125,
 /*  1630 */   193,  318,  318,  215,  318,  201,   92,  318,  318,  318,
 /*  1640 */   133,  318,  318,  270,  209,  216,  318,  318,   45,  318,
 /*  1650 */   318,  318,  318,  318,  331,  318,  318,  318,  190,  318,
 /*  1660 */   213,   53,   32,  116,  318,   46,   47,  292,  205,  350,
 /*  1670 */   284,  348,   96,    1,  359,  352,  318,  330,   37,  318,
 /*  1680 */   114,  193,  318,  318,  215,  318,  201,   92,  318,  318,
 /*  1690 */   318,  133,  318,  318,  270,  209,  216,  318,  318,   45,
 /*  1700 */   318,  318,  318,  318,  318,  331,  318,  318,  318,  111,
 /*  1710 */   318,  107,   54,   36,  109,  318,   46,   47,  292,  205,
 /*  1720 */   350,  284,  348,   96,  318,  359,  352,  318,  330,   37,
 /*  1730 */   318,  114,  199,  318,  318,  215,  318,  201,   92,  318,
 /*  1740 */   318,  318,  133,  318,  318,  270,  209,  216,  483,  318,
 /*  1750 */    45,  318,  318,  318,  483,  318,  483,  318,  483,  483,
 /*  1760 */   318,  483,  139,  318,   36,  173,  483,   46,   47,  292,
 /*  1770 */   205,  350,  277,  318,   96,   12,   11,  318,  318,  318,
 /*  1780 */   318,  483,    3,  483,  318,  318,  318,  318,  179,   92,
 /*  1790 */   128,  318,  318,  163,  483,  331,   98,  318,  318,  202,
 /*  1800 */   318,  213,   84,  277,  116,  318,   12,   11,  483,  318,
 /*  1810 */   318,  284,  348,  318,  318,  359,  352,  318,  330,  179,
 /*  1820 */   331,  318,  318,  318,  202,  318,  213,   85,  318,  116,
 /*  1830 */   318,  318,  318,  318,  318,  318,  284,  348,  318,  318,
 /*  1840 */   359,  352,  331,  330,  318,  318,  184,  318,  213,   63,
 /*  1850 */   318,  116,  318,  318,  318,  318,  318,  318,  284,  348,
 /*  1860 */   318,  318,  359,  352,  331,  330,  318,  318,  202,  318,
 /*  1870 */   213,   75,  318,  116,  318,  318,  318,  318,  318,  318,
 /*  1880 */   284,  348,  331,  318,  359,  352,  202,  330,  213,   62,
 /*  1890 */   318,  116,  318,  318,  318,  318,  318,  318,  284,  348,
 /*  1900 */   318,  318,  359,  352,  318,  330,  318,  331,  318,  318,
 /*  1910 */   318,  202,  318,  213,   76,  318,  116,  318,  318,  318,
 /*  1920 */   318,  318,  318,  284,  348,  318,  318,  359,  352,  318,
 /*  1930 */   330,  318,  318,  318,  374,  318,  318,  318,  318,   22,
 /*  1940 */   318,  318,  331,  318,  318,  215,  202,  201,  213,   60,
 /*  1950 */   318,  116,  133,  318,  318,  270,  209,  318,  284,  348,
 /*  1960 */   318,  318,  359,  352,  331,  330,  318,  318,  202,  318,
 /*  1970 */   213,   80,  318,  116,  318,  318,  318,  318,  318,  318,
 /*  1980 */   284,  348,  318,  318,  359,  352,  331,  330,  318,  318,
 /*  1990 */   202,  318,  213,   82,  318,  116,  318,  318,  318,  343,
 /*  2000 */    26,  340,  284,  348,  318,  318,  359,  352,  318,  330,
 /*  2010 */   331,  318,  318,  318,  202,  318,  213,   87,  318,  116,
 /*  2020 */   318,  318,  318,  318,  318,  318,  284,  348,  331,  318,
 /*  2030 */   359,  352,  202,  330,  213,   69,  318,  116,  318,  318,
 /*  2040 */   318,  318,  318,  318,  284,  348,  331,  318,  359,  352,
 /*  2050 */   202,  330,  213,   57,  318,  116,  318,  318,  318,  318,
 /*  2060 */   318,  318,  284,  348,  331,  318,  359,  352,  202,  330,
 /*  2070 */   213,   70,  318,  116,  318,  318,  318,  318,  318,  318,
 /*  2080 */   284,  348,  331,  318,  359,  352,  202,  330,  213,   59,
 /*  2090 */   318,  116,  318,  318,  318,  318,  318,  318,  284,  348,
 /*  2100 */   331,  318,  359,  352,  111,  330,  110,   56,  318,  109,
 /*  2110 */   318,  318,  318,  318,  318,  318,  284,  348,  331,  318,
 /*  2120 */   359,  352,  188,  330,  213,   79,  318,  116,  318,  318,
 /*  2130 */   318,  374,  318,  318,  284,  348,   22,  318,  359,  352,
 /*  2140 */   318,  330,  215,  318,  201,  318,  318,  318,  318,  133,
 /*  2150 */   331,  318,  270,  209,  202,  318,  213,   78,  318,  116,
 /*  2160 */   318,  318,  318,  318,  318,  318,  284,  348,  331,  318,
 /*  2170 */   359,  352,  202,  330,  213,   51,  318,  116,  318,  318,
 /*  2180 */   318,  318,  318,  318,  284,  348,  331,  318,  359,  352,
 /*  2190 */   202,  330,  213,   67,  318,  116,  342,   26,  340,  318,
 /*  2200 */   318,  318,  284,  348,  331,  318,  359,  352,  202,  330,
 /*  2210 */   213,   65,  318,  116,  318,  318,  318,  318,  318,  318,
 /*  2220 */   284,  348,  331,  318,  359,  352,  202,  330,  213,   64,
 /*  2230 */   318,  116,  318,  318,  318,  318,  318,  318,  284,  348,
 /*  2240 */   331,  318,  359,  352,  202,  330,  213,   86,  318,  116,
 /*  2250 */   318,  318,  318,  318,  318,  318,  284,  348,  331,  318,
 /*  2260 */   359,  352,  251,  330,  213,  318,  318,  116,  331,  318,
 /*  2270 */   318,  318,  282,  318,  213,  250,  331,  116,  359,  352,
 /*  2280 */   358,  330,  213,  318,  318,  116,  331,  318,  359,  352,
 /*  2290 */   290,  330,  213,  318,  331,  116,  359,  352,  262,  330,
 /*  2300 */   213,  318,  318,  116,  331,  318,  359,  352,  249,  330,
 /*  2310 */   213,  318,  331,  116,  359,  352,  237,  330,  213,  191,
 /*  2320 */   318,  116,  331,  318,  359,  352,  291,  330,  213,  318,
 /*  2330 */   318,  116,  359,  352,  344,  330,  318,  318,  211,  318,
 /*  2340 */    38,  318,  359,  352,  140,  330,  138,  173,  318,  173,
 /*  2350 */   318,  318,  145,  318,  277,  173,  277,   12,   11,   12,
 /*  2360 */    11,  318,  277,  318,  318,   12,   11,  318,    3,  318,
 /*  2370 */   179,  318,  179,  318,  154,  318,  128,  173,  179,  318,
 /*  2380 */   318,  318,  318,  318,  277,  318,  318,   12,   11,  318,
 /*  2390 */   318,  318,  318,  318,  318,  318,  318,  318,  318,  318,
 /*  2400 */   179,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,   81,   82,   83,    3,    4,    5,    6,    7,    8,
 /*    10 */     9,   10,   11,   12,   16,   16,   15,   82,   87,   50,
 /*    20 */    22,   22,   21,   25,   23,   56,   18,   58,   97,   28,
 /*    30 */     2,   62,   31,   32,   35,   36,   37,   38,   39,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,    4,    5,
 /*    50 */     6,    7,    8,  118,  119,   16,   12,   13,   14,   18,
 /*    60 */     1,   22,   63,   64,   65,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,    1,   16,   82,   24,   30,   20,
 /*    80 */    86,   22,   88,   89,   51,   91,   92,   34,   16,   16,
 /*    90 */    19,   19,   98,   99,   22,   22,  102,  103,   50,  105,
 /*   100 */    59,   79,   80,   81,   82,   83,   58,   18,   35,   36,
 /*   110 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   120 */    47,   48,   50,   16,   34,   87,   16,   56,   90,   22,
 /*   130 */    58,   15,   22,   17,   18,   97,   63,   64,   65,   66,
 /*   140 */    67,   68,   69,   70,   71,   72,   73,   74,    1,   33,
 /*   150 */    82,  113,   62,  106,   86,  108,   88,   89,   15,   91,
 /*   160 */    50,   18,   19,   16,   19,   20,   98,   99,   58,   22,
 /*   170 */   102,  103,   15,  105,   15,   18,   19,   18,   92,   93,
 /*   180 */   112,   22,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   190 */    43,   44,   45,   46,   47,   48,   15,   18,   15,   18,
 /*   200 */    19,   18,   59,   58,   56,   15,   25,  106,   18,   61,
 /*   210 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   220 */    73,   74,    1,  114,   82,   25,   87,   90,   86,   90,
 /*   230 */    88,   89,   15,   91,   17,   18,   97,  100,  101,   20,
 /*   240 */    98,   99,   59,   22,  102,  103,  106,  105,   27,   59,
 /*   250 */   113,   26,  113,   30,  112,   51,   35,   36,   37,   38,
 /*   260 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   270 */    50,   87,   49,   16,   90,   56,   76,   16,   58,   22,
 /*   280 */    61,   97,    1,   22,   63,   64,   65,   66,   67,   68,
 /*   290 */    69,   70,   71,   72,   73,   74,    1,  113,   82,   62,
 /*   300 */    95,   87,   86,   22,   88,   89,   49,   91,    2,   15,
 /*   310 */    49,   97,   18,  108,   98,   99,   22,   22,  102,  103,
 /*   320 */    16,  105,  108,   16,   30,   19,   22,   18,  112,   22,
 /*   330 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   340 */    45,   46,   47,   48,   18,   16,  107,   87,  109,  110,
 /*   350 */    60,   22,   17,   18,   25,   50,   49,   97,   63,   64,
 /*   360 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   370 */     1,   82,   87,  113,   87,   86,  114,   88,   89,   87,
 /*   380 */    91,    1,   97,   15,   97,   16,   18,   98,   99,   97,
 /*   390 */    22,  102,  103,  108,  105,   60,   16,   16,   30,   22,
 /*   400 */   108,  112,   22,   22,   35,   36,   37,   38,   39,   40,
 /*   410 */    41,   42,   43,   44,   45,   46,   47,   48,   16,   16,
 /*   420 */    87,   16,   18,   15,   22,   22,   18,   22,  109,  110,
 /*   430 */    97,   17,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   440 */    71,   72,   73,   74,    1,   82,  113,   88,   87,   86,
 /*   450 */    91,   88,   89,   17,   91,   17,   18,   16,   97,   16,
 /*   460 */    20,   98,   99,   22,  105,  102,  103,   16,  105,  108,
 /*   470 */    18,   16,   15,   22,   83,   18,   85,   22,   35,   36,
 /*   480 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   490 */    47,   48,    1,   87,   87,   16,   16,   15,   58,   16,
 /*   500 */    18,   22,   22,   97,   97,   22,   63,   64,   65,   66,
 /*   510 */    67,   68,   69,   70,   71,   72,   73,   74,   16,  113,
 /*   520 */   113,  106,   15,  108,   22,   18,   35,   36,   37,   38,
 /*   530 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   540 */    95,   16,   51,   16,   16,   16,   16,   22,   22,   22,
 /*   550 */    22,   22,   17,  108,   63,   64,   65,   66,   67,   68,
 /*   560 */    69,   70,   71,   72,   73,   74,    1,   82,  109,  110,
 /*   570 */   104,   86,   16,   88,   89,   87,   91,  111,   22,   49,
 /*   580 */    16,   16,   15,   98,   99,   97,   22,  102,  103,   16,
 /*   590 */   105,   16,   16,   25,   50,   22,   15,   22,   22,   18,
 /*   600 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   610 */    45,   46,   47,   48,    1,  104,   18,   50,   17,   60,
 /*   620 */    49,   33,  111,   51,   33,   82,   56,   95,   63,   64,
 /*   630 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   640 */   108,   16,    2,   17,   52,   22,   18,   34,   35,   36,
 /*   650 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   660 */    47,   48,  119,  106,   87,   87,   97,  107,   20,   22,
 /*   670 */   108,  110,    2,   17,   97,   97,   63,   64,   65,   66,
 /*   680 */    67,   68,   69,   70,   71,   72,   73,   74,    1,   82,
 /*   690 */   111,   95,  106,   86,   95,   88,   89,   94,   91,   22,
 /*   700 */    95,   95,   92,   95,  108,   98,   99,  108,   96,  102,
 /*   710 */   103,   24,  105,  108,  108,  115,  108,  113,    1,   84,
 /*   720 */   108,   94,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   730 */    43,   44,   45,   46,   47,   48,   95,   13,  120,  120,
 /*   740 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  108,
 /*   750 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   760 */    73,   74,    1,   82,  120,  120,  120,   86,  120,   88,
 /*   770 */    89,  120,   91,  120,   95,   95,  120,   16,  120,   98,
 /*   780 */    99,  120,  120,  102,  103,  120,  105,  108,  108,  120,
 /*   790 */   120,  120,  120,  120,  120,  120,   35,   36,   37,   38,
 /*   800 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*   810 */     1,    2,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   820 */   120,  120,  120,  120,   63,   64,   65,   66,   67,   68,
 /*   830 */    69,   70,   71,   72,   73,   74,  120,  120,  120,  120,
 /*   840 */   120,  120,  120,  120,   35,   36,   37,   38,   39,   40,
 /*   850 */    41,   42,   43,   44,   45,   46,   47,   48,    1,  120,
 /*   860 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   870 */   120,  120,   63,   64,   65,   66,   67,   68,   69,   70,
 /*   880 */    71,   72,   73,   74,  120,  120,  120,  120,  120,  120,
 /*   890 */   120,  120,   35,   36,   37,   38,   39,   40,   41,   42,
 /*   900 */    43,   44,   45,   46,   47,   48,    1,  120,   51,  120,
 /*   910 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*   920 */    63,   64,   65,   66,   67,   68,   69,   70,   71,   72,
 /*   930 */    73,   74,  120,  120,   29,  120,  120,  120,  120,  120,
 /*   940 */    35,   36,   37,   38,   39,   40,   41,   42,   43,   44,
 /*   950 */    45,   46,   47,   48,    1,  120,  120,  120,  120,  120,
 /*   960 */   120,  120,  120,  120,  120,  120,  120,  120,   63,   64,
 /*   970 */    65,   66,   67,   68,   69,   70,   71,   72,   73,   74,
 /*   980 */   120,  120,  120,  120,  120,  120,  120,  120,   35,   36,
 /*   990 */    37,   38,   39,   40,   41,   42,   43,   44,   45,   46,
 /*  1000 */    47,   48,    1,  120,  120,  120,  120,  120,  120,  120,
 /*  1010 */   120,  120,  120,  120,  120,   62,   63,   64,   65,   66,
 /*  1020 */    67,   68,   69,   70,   71,   72,   73,   74,  120,  120,
 /*  1030 */   120,  120,  120,  120,  120,  120,   35,   36,   37,   38,
 /*  1040 */    39,   40,   41,   42,   43,   44,   45,   46,   47,   48,
 /*  1050 */     1,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1060 */   120,  120,  120,  120,   63,   64,   65,   66,   67,   68,
 /*  1070 */    69,   70,   71,   72,   73,   74,  120,   76,  120,  120,
 /*  1080 */   120,  120,  120,  120,   35,   36,   37,   38,   39,   40,
 /*  1090 */    41,   42,   43,   44,   45,   46,   47,   48,  120,  120,
 /*  1100 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1110 */   120,  120,   63,   64,   65,   66,   67,   68,   69,   70,
 /*  1120 */    71,   72,   73,   74,   35,   36,   37,   38,   39,   40,
 /*  1130 */    41,   42,   43,   44,   45,   46,   47,   48,  120,  120,
 /*  1140 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  1150 */   120,  120,   63,   64,   65,   66,   67,   68,   69,   70,
 /*  1160 */    71,   72,   73,   74,  120,  120,  120,  120,   15,  120,
 /*  1170 */    17,   18,  120,   82,   21,  120,   23,   86,  120,   88,
 /*  1180 */   120,   28,   91,  120,   31,   32,   33,  120,  120,   36,
 /*  1190 */    99,   16,  120,  102,  103,  120,  105,   22,  120,  120,
 /*  1200 */   120,  120,  120,   50,   29,  120,   53,   54,   55,   56,
 /*  1210 */    57,  120,  120,   60,   61,   62,  120,  120,  120,   15,
 /*  1220 */   120,   17,   18,  120,   49,   21,  120,   23,   75,  120,
 /*  1230 */   120,  120,   28,  120,  120,   31,   32,   33,  120,  120,
 /*  1240 */    36,  120,  120,  120,  120,  120,   82,  120,  120,  120,
 /*  1250 */    86,  120,   88,   89,   50,   91,  120,   53,   54,   55,
 /*  1260 */    56,   57,   98,   99,   60,   61,  102,  103,  120,  105,
 /*  1270 */    15,  120,   17,   18,  120,  120,   21,  120,   23,   75,
 /*  1280 */   116,  117,  120,   28,  120,  120,   31,   32,   33,  120,
 /*  1290 */   120,   36,  120,  120,  120,  120,  120,   82,  120,  120,
 /*  1300 */   120,   86,  120,   88,   89,   50,   91,  120,   53,   54,
 /*  1310 */    55,   56,   57,   98,   99,   60,   61,  102,  103,  120,
 /*  1320 */   105,   15,  120,   17,   18,  120,  120,   21,  120,   23,
 /*  1330 */    75,  120,  117,  120,   28,  120,  120,   31,   32,   33,
 /*  1340 */   120,  120,   36,  120,  120,  120,  120,  120,   82,  120,
 /*  1350 */   120,  120,   86,  120,   88,   89,   50,   91,  120,   53,
 /*  1360 */    54,   55,   56,   57,   98,   99,   60,   61,  102,  103,
 /*  1370 */   120,  105,   15,  120,   17,   18,  120,  120,   21,  120,
 /*  1380 */    23,   75,  120,  120,  120,   28,  120,  120,   31,   32,
 /*  1390 */    33,  120,  120,   36,  120,  120,  120,  120,  120,   82,
 /*  1400 */   120,  120,  120,   86,  120,   88,   89,   50,   91,  120,
 /*  1410 */    53,   54,   55,   56,   57,   98,   99,   60,   61,  102,
 /*  1420 */   103,  120,  105,   15,  120,   17,   18,  120,  120,   21,
 /*  1430 */   120,   23,   75,  120,  120,  120,   28,  120,  120,   31,
 /*  1440 */    32,   33,  120,  120,   36,  120,  120,  120,  120,  120,
 /*  1450 */    82,  120,  120,  120,   86,  120,   88,   89,   50,   91,
 /*  1460 */   120,   53,   54,   55,   56,   57,   98,   99,   60,   61,
 /*  1470 */   102,  103,  120,  105,   15,  120,   17,   18,  120,  120,
 /*  1480 */    21,  120,   23,   75,  120,  120,  120,   28,  120,  120,
 /*  1490 */    31,   32,   33,  120,  120,   36,  120,  120,  120,  120,
 /*  1500 */   120,   82,  120,  120,  120,   86,  120,   88,   89,   50,
 /*  1510 */    91,  120,   53,   54,   55,   56,   57,   98,   99,   60,
 /*  1520 */    61,  102,  103,  120,  105,   15,  120,   17,   18,  120,
 /*  1530 */   120,   21,  120,   23,   75,  120,  120,  120,   28,  120,
 /*  1540 */   120,   31,   32,   33,  120,  120,   36,  120,  120,  120,
 /*  1550 */   120,  120,   82,  120,  120,  120,   86,  120,   88,   89,
 /*  1560 */    50,   91,  120,   53,   54,   55,   56,   57,   98,   99,
 /*  1570 */    60,   61,  102,  103,  120,  105,   15,  120,   17,   18,
 /*  1580 */   120,  120,   21,  120,   23,   75,  120,  120,  120,   28,
 /*  1590 */   120,  120,   31,   32,   33,  120,  120,   36,  120,  120,
 /*  1600 */   120,  120,  120,   82,  120,  120,  120,   86,  120,   88,
 /*  1610 */    89,   50,   91,  120,   53,   54,   55,   56,   57,   98,
 /*  1620 */    99,   60,   61,  102,  103,  120,  105,   15,  120,   17,
 /*  1630 */    18,  120,  120,   21,  120,   23,   75,  120,  120,  120,
 /*  1640 */    28,  120,  120,   31,   32,   33,  120,  120,   36,  120,
 /*  1650 */   120,  120,  120,  120,   82,  120,  120,  120,   86,  120,
 /*  1660 */    88,   89,   50,   91,  120,   53,   54,   55,   56,   57,
 /*  1670 */    98,   99,   60,   61,  102,  103,  120,  105,   15,  120,
 /*  1680 */    17,   18,  120,  120,   21,  120,   23,   75,  120,  120,
 /*  1690 */   120,   28,  120,  120,   31,   32,   33,  120,  120,   36,
 /*  1700 */   120,  120,  120,  120,  120,   82,  120,  120,  120,   86,
 /*  1710 */   120,   88,   89,   50,   91,  120,   53,   54,   55,   56,
 /*  1720 */    57,   98,   99,   60,  120,  102,  103,  120,  105,   15,
 /*  1730 */   120,   17,   18,  120,  120,   21,  120,   23,   75,  120,
 /*  1740 */   120,  120,   28,  120,  120,   31,   32,   33,   16,  120,
 /*  1750 */    36,  120,  120,  120,   22,  120,   24,  120,   26,   27,
 /*  1760 */   120,   29,   87,  120,   50,   90,   34,   53,   54,   55,
 /*  1770 */    56,   57,   97,  120,   60,  100,  101,  120,  120,  120,
 /*  1780 */   120,   49,   50,   51,  120,  120,  120,  120,  113,   75,
 /*  1790 */    58,  120,  120,   87,   62,   82,   90,  120,  120,   86,
 /*  1800 */   120,   88,   89,   97,   91,  120,  100,  101,   76,  120,
 /*  1810 */   120,   98,   99,  120,  120,  102,  103,  120,  105,  113,
 /*  1820 */    82,  120,  120,  120,   86,  120,   88,   89,  120,   91,
 /*  1830 */   120,  120,  120,  120,  120,  120,   98,   99,  120,  120,
 /*  1840 */   102,  103,   82,  105,  120,  120,   86,  120,   88,   89,
 /*  1850 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  1860 */   120,  120,  102,  103,   82,  105,  120,  120,   86,  120,
 /*  1870 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  1880 */    98,   99,   82,  120,  102,  103,   86,  105,   88,   89,
 /*  1890 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  1900 */   120,  120,  102,  103,  120,  105,  120,   82,  120,  120,
 /*  1910 */   120,   86,  120,   88,   89,  120,   91,  120,  120,  120,
 /*  1920 */   120,  120,  120,   98,   99,  120,  120,  102,  103,  120,
 /*  1930 */   105,  120,  120,  120,   10,  120,  120,  120,  120,   15,
 /*  1940 */   120,  120,   82,  120,  120,   21,   86,   23,   88,   89,
 /*  1950 */   120,   91,   28,  120,  120,   31,   32,  120,   98,   99,
 /*  1960 */   120,  120,  102,  103,   82,  105,  120,  120,   86,  120,
 /*  1970 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  1980 */    98,   99,  120,  120,  102,  103,   82,  105,  120,  120,
 /*  1990 */    86,  120,   88,   89,  120,   91,  120,  120,  120,   75,
 /*  2000 */    76,   77,   98,   99,  120,  120,  102,  103,  120,  105,
 /*  2010 */    82,  120,  120,  120,   86,  120,   88,   89,  120,   91,
 /*  2020 */   120,  120,  120,  120,  120,  120,   98,   99,   82,  120,
 /*  2030 */   102,  103,   86,  105,   88,   89,  120,   91,  120,  120,
 /*  2040 */   120,  120,  120,  120,   98,   99,   82,  120,  102,  103,
 /*  2050 */    86,  105,   88,   89,  120,   91,  120,  120,  120,  120,
 /*  2060 */   120,  120,   98,   99,   82,  120,  102,  103,   86,  105,
 /*  2070 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  2080 */    98,   99,   82,  120,  102,  103,   86,  105,   88,   89,
 /*  2090 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2100 */    82,  120,  102,  103,   86,  105,   88,   89,  120,   91,
 /*  2110 */   120,  120,  120,  120,  120,  120,   98,   99,   82,  120,
 /*  2120 */   102,  103,   86,  105,   88,   89,  120,   91,  120,  120,
 /*  2130 */   120,   10,  120,  120,   98,   99,   15,  120,  102,  103,
 /*  2140 */   120,  105,   21,  120,   23,  120,  120,  120,  120,   28,
 /*  2150 */    82,  120,   31,   32,   86,  120,   88,   89,  120,   91,
 /*  2160 */   120,  120,  120,  120,  120,  120,   98,   99,   82,  120,
 /*  2170 */   102,  103,   86,  105,   88,   89,  120,   91,  120,  120,
 /*  2180 */   120,  120,  120,  120,   98,   99,   82,  120,  102,  103,
 /*  2190 */    86,  105,   88,   89,  120,   91,   75,   76,   77,  120,
 /*  2200 */   120,  120,   98,   99,   82,  120,  102,  103,   86,  105,
 /*  2210 */    88,   89,  120,   91,  120,  120,  120,  120,  120,  120,
 /*  2220 */    98,   99,   82,  120,  102,  103,   86,  105,   88,   89,
 /*  2230 */   120,   91,  120,  120,  120,  120,  120,  120,   98,   99,
 /*  2240 */    82,  120,  102,  103,   86,  105,   88,   89,  120,   91,
 /*  2250 */   120,  120,  120,  120,  120,  120,   98,   99,   82,  120,
 /*  2260 */   102,  103,   86,  105,   88,  120,  120,   91,   82,  120,
 /*  2270 */   120,  120,   86,  120,   88,   99,   82,   91,  102,  103,
 /*  2280 */    86,  105,   88,  120,  120,   91,   82,  120,  102,  103,
 /*  2290 */    86,  105,   88,  120,   82,   91,  102,  103,   86,  105,
 /*  2300 */    88,  120,  120,   91,   82,  120,  102,  103,   86,  105,
 /*  2310 */    88,  120,   82,   91,  102,  103,   86,  105,   88,    1,
 /*  2320 */   120,   91,   82,  120,  102,  103,   86,  105,   88,  120,
 /*  2330 */   120,   91,  102,  103,   16,  105,  120,  120,   20,  120,
 /*  2340 */    22,  120,  102,  103,   87,  105,   87,   90,  120,   90,
 /*  2350 */   120,  120,   87,  120,   97,   90,   97,  100,  101,  100,
 /*  2360 */   101,  120,   97,  120,  120,  100,  101,  120,   50,  120,
 /*  2370 */   113,  120,  113,  120,   87,  120,   58,   90,  113,  120,
 /*  2380 */   120,  120,  120,  120,   97,  120,  120,  100,  101,  120,
 /*  2390 */   120,  120,  120,  120,  120,  120,  120,  120,  120,  120,
 /*  2400 */   113,
);
    const YY_SHIFT_USE_DFLT = -32;
    const YY_SHIFT_MAX = 233;
    static public $yy_shift_ofst = array(
 /*     0 */     1, 1306, 1204, 1204, 1204, 1204, 1612, 1306, 1153, 1204,
 /*    10 */  1204, 1204, 1204, 1204, 1561, 1204, 1408, 1204, 1204, 1204,
 /*    20 */  1204, 1204, 1510, 1204, 1204, 1204, 1204, 1204, 1204, 1204,
 /*    30 */  1204, 1204, 1204, 1357, 1459, 1204, 1204, 1510, 1408, 1204,
 /*    40 */  1204, 1204, 1255, 1255, 1663, 1663, 1663, 1663, 1714, 1663,
 /*    50 */  1663,  221,  147,   -1,   73,  295,  295,  295,  369,  491,
 /*    60 */   443,  613,  565,  905,  809,  857,  761,  953, 1001,  687,
 /*    70 */  1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049, 1049,
 /*    80 */  1049, 1049, 1049, 1049, 1049, 1049, 1089, 1089, 2318,   59,
 /*    90 */   281,    1, 1924,  368,  294,  219,  335,  159,  380,  159,
 /*   100 */   281,  281,  281, 2121,   44,  143,  181,   -2,  183,  145,
 /*   110 */   329,  261,  408,  482,  408,  576,  440,  408,  408,  438,
 /*   120 */   457,  408,  408,  408,  581,  507,  408,  408,  438,  507,
 /*   130 */   648,  648,  377,  647,  656,  217,  190,  157,  479,  483,
 /*   140 */   527,  480,  148,  525,  528,  405,  381,   39,  402,  455,
 /*   150 */   441,  451,  403,  107,  502,  148,  148,  148,  567,  148,
 /*   160 */   556,  564,  529,  575,  573,  304,  648,  670,  724,  544,
 /*   170 */   677,  677,  648,  717,  670,  648,  656,  -32,  -32,  -32,
 /*   180 */   -32, 1732,   72,  110, 1175,  116,  -31,  307,  257,   48,
 /*   190 */   530,   41,   53,  220,   90,  223,  306,  200,   71,  220,
 /*   200 */    33,  623,  571,  305,  588,  591,  626,  640,  544,  598,
 /*   210 */   414,  628,  436,  568,  601,  526,  570,  535,  452,  404,
 /*   220 */   625,  592,  559,  572,   89,   28,    8,  237,  309,  179,
 /*   230 */   326,  290,  204,  225,
);
    const YY_REDUCE_USE_DFLT = -81;
    const YY_REDUCE_MAX = 180;
    static public $yy_reduce_ofst = array(
 /*     0 */    22, 1164,  289,   68,  142,  216,   -6, 1215, 2104, 1470,
 /*    10 */  1266,  607, 1904, 1738, 1368, 1782, 1760, 1713, 1800, 1825,
 /*    20 */  1882, 1860, 1623, 1572,  681,  485,  363, 1317, 1521, 1946,
 /*    30 */  1419, 1928, 2122, 2158, 2140, 1982, 2000, 2018, 2036, 1964,
 /*    40 */  2086, 2068, 2176, 1091, 2230, 2186, 2204, 2240, 2212, 2194,
 /*    50 */  2222, 1675, 2259, 2287, 1706, 2265, 1706, 2257,  137,  137,
 /*    60 */   137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*    70 */   137,  137,  137,  137,  137,  137,  137,  137,  137,  137,
 /*    80 */   137,  137,  137,  137,  137,  137,  137,  137,  184,   38,
 /*    90 */   139,  -80,  -65,  214,  285,  239,  359,  361,  260,  292,
 /*   100 */   407,  333,  406,  543,  391,  415,  612,  578,  415,  319,
 /*   110 */   578,  577,  605,  606,  599,  488,  319,  205,  445,  466,
 /*   120 */   596,  532,   47,  679,  599,  641,  680,  608,  511,  599,
 /*   130 */   459,  319,  287,  -69,   86,  579,  562,  562,  569,  569,
 /*   140 */   569,  569,  560,  569,  569,  569,  569,  569,  569,  569,
 /*   150 */   569,  569,  569,  569,  569,  560,  560,  560,  557,  560,
 /*   160 */   569,  569,  569,  569,  569,  569,  561,  600,  635,  586,
 /*   170 */   627,  603,  561,  604,  600,  561,  610,  262,  140,  109,
 /*   180 */   101,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 1 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 2 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 3 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 4 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 5 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 6 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 7 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 8 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 62, 75, ),
        /* 9 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 10 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 11 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 12 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 13 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 14 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 15 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 16 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 17 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 18 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 19 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 20 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 21 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 22 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 23 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 24 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 25 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 26 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 27 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 28 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 29 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 30 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 31 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 32 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 33 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 34 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 35 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 36 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 37 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 38 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 39 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 40 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 41 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 42 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 43 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 61, 75, ),
        /* 44 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 45 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 46 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 47 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 48 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 49 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 50 */ array(15, 17, 18, 21, 23, 28, 31, 32, 33, 36, 50, 53, 54, 55, 56, 57, 60, 75, ),
        /* 51 */ array(1, 22, 27, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 52 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 53 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 54 */ array(1, 16, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 55 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 56 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 57 */ array(1, 22, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 58 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 59 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 51, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 60 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 61 */ array(1, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 62 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 63 */ array(1, 29, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 64 */ array(1, 2, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 65 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 51, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 66 */ array(1, 16, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 67 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 68 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 76, ),
        /* 69 */ array(1, 24, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 70 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 71 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 72 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 73 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 74 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 75 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 76 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 77 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 78 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 79 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 80 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 81 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 82 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 83 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 84 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 85 */ array(1, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 86 */ array(35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 87 */ array(35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, ),
        /* 88 */ array(1, 16, 20, 22, 50, 58, ),
        /* 89 */ array(1, 16, 20, 22, ),
        /* 90 */ array(1, 22, ),
        /* 91 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 15, 21, 23, 28, 31, 32, ),
        /* 92 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 93 */ array(15, 18, 22, 30, ),
        /* 94 */ array(15, 18, 22, 30, ),
        /* 95 */ array(20, 56, 61, ),
        /* 96 */ array(17, 18, 60, ),
        /* 97 */ array(15, 18, 22, ),
        /* 98 */ array(1, 16, 22, ),
        /* 99 */ array(15, 18, 22, ),
        /* 100 */ array(1, 22, ),
        /* 101 */ array(1, 22, ),
        /* 102 */ array(1, 22, ),
        /* 103 */ array(10, 15, 21, 23, 28, 31, 32, 75, 76, 77, ),
        /* 104 */ array(4, 5, 6, 7, 8, 12, 13, 14, ),
        /* 105 */ array(15, 18, 19, 59, ),
        /* 106 */ array(15, 18, 19, 25, ),
        /* 107 */ array(16, 22, 25, ),
        /* 108 */ array(15, 18, 59, ),
        /* 109 */ array(19, 20, 58, ),
        /* 110 */ array(16, 22, 25, ),
        /* 111 */ array(16, 22, 49, ),
        /* 112 */ array(15, 18, ),
        /* 113 */ array(15, 18, ),
        /* 114 */ array(15, 18, ),
        /* 115 */ array(16, 22, ),
        /* 116 */ array(20, 58, ),
        /* 117 */ array(15, 18, ),
        /* 118 */ array(15, 18, ),
        /* 119 */ array(17, 18, ),
        /* 120 */ array(15, 18, ),
        /* 121 */ array(15, 18, ),
        /* 122 */ array(15, 18, ),
        /* 123 */ array(15, 18, ),
        /* 124 */ array(15, 18, ),
        /* 125 */ array(15, 18, ),
        /* 126 */ array(15, 18, ),
        /* 127 */ array(15, 18, ),
        /* 128 */ array(17, 18, ),
        /* 129 */ array(15, 18, ),
        /* 130 */ array(20, ),
        /* 131 */ array(20, ),
        /* 132 */ array(22, ),
        /* 133 */ array(22, ),
        /* 134 */ array(17, ),
        /* 135 */ array(15, 17, 18, ),
        /* 136 */ array(15, 18, 59, ),
        /* 137 */ array(15, 18, 19, ),
        /* 138 */ array(16, 22, ),
        /* 139 */ array(16, 22, ),
        /* 140 */ array(16, 22, ),
        /* 141 */ array(16, 22, ),
        /* 142 */ array(56, 61, ),
        /* 143 */ array(16, 22, ),
        /* 144 */ array(16, 22, ),
        /* 145 */ array(16, 22, ),
        /* 146 */ array(16, 22, ),
        /* 147 */ array(16, 22, ),
        /* 148 */ array(16, 22, ),
        /* 149 */ array(16, 22, ),
        /* 150 */ array(16, 22, ),
        /* 151 */ array(16, 22, ),
        /* 152 */ array(16, 22, ),
        /* 153 */ array(16, 22, ),
        /* 154 */ array(16, 22, ),
        /* 155 */ array(56, 61, ),
        /* 156 */ array(56, 61, ),
        /* 157 */ array(56, 61, ),
        /* 158 */ array(15, 50, ),
        /* 159 */ array(56, 61, ),
        /* 160 */ array(16, 22, ),
        /* 161 */ array(16, 22, ),
        /* 162 */ array(16, 22, ),
        /* 163 */ array(16, 22, ),
        /* 164 */ array(16, 22, ),
        /* 165 */ array(16, 22, ),
        /* 166 */ array(20, ),
        /* 167 */ array(2, ),
        /* 168 */ array(13, ),
        /* 169 */ array(50, ),
        /* 170 */ array(22, ),
        /* 171 */ array(22, ),
        /* 172 */ array(20, ),
        /* 173 */ array(1, ),
        /* 174 */ array(2, ),
        /* 175 */ array(20, ),
        /* 176 */ array(17, ),
        /* 177 */ array(),
        /* 178 */ array(),
        /* 179 */ array(),
        /* 180 */ array(),
        /* 181 */ array(16, 22, 24, 26, 27, 29, 34, 49, 50, 51, 58, 62, 76, ),
        /* 182 */ array(16, 19, 22, 50, 58, ),
        /* 183 */ array(16, 22, 50, 58, ),
        /* 184 */ array(16, 22, 29, 49, ),
        /* 185 */ array(15, 17, 18, 33, ),
        /* 186 */ array(50, 56, 58, 62, ),
        /* 187 */ array(16, 22, 49, ),
        /* 188 */ array(16, 22, 49, ),
        /* 189 */ array(30, 50, 58, ),
        /* 190 */ array(16, 49, ),
        /* 191 */ array(18, 59, ),
        /* 192 */ array(24, 34, ),
        /* 193 */ array(50, 58, ),
        /* 194 */ array(34, 62, ),
        /* 195 */ array(30, 49, ),
        /* 196 */ array(2, 19, ),
        /* 197 */ array(25, 76, ),
        /* 198 */ array(19, 56, ),
        /* 199 */ array(50, 58, ),
        /* 200 */ array(51, ),
        /* 201 */ array(22, ),
        /* 202 */ array(49, ),
        /* 203 */ array(50, ),
        /* 204 */ array(33, ),
        /* 205 */ array(33, ),
        /* 206 */ array(17, ),
        /* 207 */ array(2, ),
        /* 208 */ array(50, ),
        /* 209 */ array(18, ),
        /* 210 */ array(17, ),
        /* 211 */ array(18, ),
        /* 212 */ array(17, ),
        /* 213 */ array(25, ),
        /* 214 */ array(17, ),
        /* 215 */ array(22, ),
        /* 216 */ array(56, ),
        /* 217 */ array(17, ),
        /* 218 */ array(18, ),
        /* 219 */ array(18, ),
        /* 220 */ array(16, ),
        /* 221 */ array(52, ),
        /* 222 */ array(60, ),
        /* 223 */ array(51, ),
        /* 224 */ array(18, ),
        /* 225 */ array(2, ),
        /* 226 */ array(18, ),
        /* 227 */ array(62, ),
        /* 228 */ array(18, ),
        /* 229 */ array(18, ),
        /* 230 */ array(18, ),
        /* 231 */ array(60, ),
        /* 232 */ array(51, ),
        /* 233 */ array(26, ),
        /* 234 */ array(),
        /* 235 */ array(),
        /* 236 */ array(),
        /* 237 */ array(),
        /* 238 */ array(),
        /* 239 */ array(),
        /* 240 */ array(),
        /* 241 */ array(),
        /* 242 */ array(),
        /* 243 */ array(),
        /* 244 */ array(),
        /* 245 */ array(),
        /* 246 */ array(),
        /* 247 */ array(),
        /* 248 */ array(),
        /* 249 */ array(),
        /* 250 */ array(),
        /* 251 */ array(),
        /* 252 */ array(),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
);
    static public $yy_default = array(
 /*     0 */   378,  554,  525,  525,  525,  525,  571,  571,  571,  571,
 /*    10 */   571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
 /*    20 */   571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
 /*    30 */   571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
 /*    40 */   571,  571,  571,  571,  571,  571,  571,  571,  571,  571,
 /*    50 */   571,  436,  571,  571,  571,  436,  436,  436,  571,  571,
 /*    60 */   571,  524,  571,  441,  571,  571,  571,  571,  571,  571,
 /*    70 */   464,  467,  458,  557,  556,  420,  463,  555,  446,  441,
 /*    80 */   468,  460,  455,  438,  443,  459,  471,  472,  483,  571,
 /*    90 */   436,  375,  571,  436,  436,  537,  571,  436,  454,  436,
 /*   100 */   436,  436,  436,  571,  571,  498,  571,  473,  498,  491,
 /*   110 */   473,  447,  571,  571,  571,  571,  491,  571,  571,  571,
 /*   120 */   571,  571,  498,  571,  571,  571,  571,  571,  571,  571,
 /*   130 */   534,  491,  436,  436,  571,  571,  499,  571,  571,  571,
 /*   140 */   571,  571,  516,  571,  571,  571,  571,  571,  571,  571,
 /*   150 */   571,  571,  571,  571,  571,  518,  496,  515,  498,  517,
 /*   160 */   571,  571,  571,  571,  571,  571,  512,  527,  393,  498,
 /*   170 */   570,  570,  535,  454,  526,  538,  571,  531,  498,  531,
 /*   180 */   498,  449,  483,  483,  447,  571,  483,  447,  447,  483,
 /*   190 */   447,  571,  571,  483,  571,  447,  510,  473,  479,  469,
 /*   200 */   571,  571,  447,  536,  481,  571,  571,  510,  510,  571,
 /*   210 */   571,  571,  571,  473,  571,  571,  479,  571,  571,  571,
 /*   220 */   571,  485,  571,  571,  571,  510,  571,  571,  571,  571,
 /*   230 */   571,  571,  571,  444,  495,  552,  421,  451,  551,  376,
 /*   240 */   422,  507,  569,  504,  553,  445,  506,  485,  423,  450,
 /*   250 */   533,  532,  522,  433,  511,  417,  418,  523,  427,  505,
 /*   260 */   520,  503,  470,  519,  521,  561,  428,  494,  550,  430,
 /*   270 */   429,  431,  432,  530,  510,  509,  419,  435,  424,  425,
 /*   280 */   426,  477,  474,  449,  448,  492,  497,  500,  488,  482,
 /*   290 */   475,  476,  478,  480,  416,  415,  386,  385,  387,  388,
 /*   300 */   389,  384,  383,  379,  377,  380,  381,  382,  390,  391,
 /*   310 */   400,  399,  401,  402,  434,  398,  397,  392,  394,  395,
 /*   320 */   396,  508,  501,  406,  566,  407,  408,  409,  405,  404,
 /*   330 */   493,  490,  514,  403,  565,  513,  410,  563,  560,  562,
 /*   340 */   564,  567,  559,  558,  411,  412,  414,  413,  453,  549,
 /*   350 */   486,  457,  487,  489,  461,  456,  529,  502,  452,  484,
 /*   360 */   528,  462,  465,  545,  544,  546,  547,  548,  543,  542,
 /*   370 */   466,  539,  540,  541,  568,
);
    const YYNOCODE = 121;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 375;
    const YYNRULE = 196;
    const YYERRORSYMBOL = 78;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array( 
  '$',             'VERT',          'COLON',         'COMMENT',     
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',   
  'FAKEPHPSTARTTAG',  'XMLTAG',        'OTHER',         'LINEBREAK',   
  'LITERALSTART',  'LITERALEND',    'LITERAL',       'LDEL',        
  'RDEL',          'DOLLAR',        'ID',            'EQUAL',       
  'PTR',           'LDELIF',        'SPACE',         'LDELFOR',     
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',        
  'LDELFOREACH',   'AS',            'APTR',          'SMARTYBLOCKCHILD',
  'LDELSLASH',     'INTEGER',       'COMMA',         'MATH',        
  'UNIMATH',       'ANDSYM',        'ISIN',          'ISDIVBY',     
  'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',     'ISEVENBY',    
  'ISNOTEVENBY',   'ISODD',         'ISNOTODD',      'ISODDBY',     
  'ISNOTODDBY',    'INSTANCEOF',    'OPENP',         'CLOSEP',      
  'QMARK',         'NOT',           'TYPECAST',      'HEX',         
  'DOT',           'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',          
  'HATCH',         'OPENB',         'CLOSEB',        'EQUALS',      
  'NOTEQUALS',     'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',
  'LESSEQUAL',     'IDENTITY',      'NONEIDENTITY',  'MOD',         
  'LAND',          'LOR',           'LXOR',          'QUOTE',       
  'BACKTICK',      'DOLLARID',      'error',         'start',       
  'template',      'template_element',  'smartytag',     'literal',     
  'literal_elements',  'literal_element',  'value',         'attributes',  
  'variable',      'expr',          'modifierlist',  'varindexed',  
  'statement',     'statements',    'optspace',      'varvar',      
  'foraction',     'attribute',     'ternary',       'array',       
  'ifcond',        'lop',           'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',    
  'varvarele',     'objectchain',   'objectelement',  'method',      
  'params',        'modifier',      'modparameters',  'modparameter',
  'arrayelements',  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= OTHER",
 /*  14 */ "template_element ::= LINEBREAK",
 /*  15 */ "literal ::= LITERALSTART LITERALEND",
 /*  16 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  17 */ "literal_elements ::= literal_elements literal_element",
 /*  18 */ "literal_elements ::=",
 /*  19 */ "literal_element ::= literal",
 /*  20 */ "literal_element ::= LITERAL",
 /*  21 */ "literal_element ::= PHPSTARTTAG",
 /*  22 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  23 */ "literal_element ::= PHPENDTAG",
 /*  24 */ "literal_element ::= ASPSTARTTAG",
 /*  25 */ "literal_element ::= ASPENDTAG",
 /*  26 */ "smartytag ::= LDEL value RDEL",
 /*  27 */ "smartytag ::= LDEL value attributes RDEL",
 /*  28 */ "smartytag ::= LDEL variable attributes RDEL",
 /*  29 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  31 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  34 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID RDEL",
 /*  37 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  38 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDELIF SPACE expr RDEL",
 /*  41 */ "smartytag ::= LDELIF SPACE expr attributes RDEL",
 /*  42 */ "smartytag ::= LDELIF SPACE statement RDEL",
 /*  43 */ "smartytag ::= LDELIF SPACE statement attributes RDEL",
 /*  44 */ "smartytag ::= LDELFOR SPACE statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  45 */ "foraction ::= EQUAL expr",
 /*  46 */ "foraction ::= INCDEC",
 /*  47 */ "smartytag ::= LDELFOR SPACE statement TO expr attributes RDEL",
 /*  48 */ "smartytag ::= LDELFOR SPACE statement TO expr STEP expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  55 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  56 */ "smartytag ::= LDELSLASH ID attributes RDEL",
 /*  57 */ "smartytag ::= LDELSLASH ID modifierlist attributes RDEL",
 /*  58 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  59 */ "attributes ::= attributes attribute",
 /*  60 */ "attributes ::= attribute",
 /*  61 */ "attributes ::=",
 /*  62 */ "attribute ::= SPACE ID EQUAL ID",
 /*  63 */ "attribute ::= SPACE ID EQUAL expr",
 /*  64 */ "attribute ::= SPACE ID EQUAL value",
 /*  65 */ "attribute ::= SPACE ID",
 /*  66 */ "attribute ::= SPACE expr",
 /*  67 */ "attribute ::= SPACE value",
 /*  68 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  69 */ "statements ::= statement",
 /*  70 */ "statements ::= statements COMMA statement",
 /*  71 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  72 */ "expr ::= value",
 /*  73 */ "expr ::= ternary",
 /*  74 */ "expr ::= DOLLAR ID COLON ID",
 /*  75 */ "expr ::= expr MATH value",
 /*  76 */ "expr ::= expr UNIMATH value",
 /*  77 */ "expr ::= expr ANDSYM value",
 /*  78 */ "expr ::= array",
 /*  79 */ "expr ::= expr modifierlist",
 /*  80 */ "expr ::= expr ifcond expr",
 /*  81 */ "expr ::= expr ISIN array",
 /*  82 */ "expr ::= expr ISIN value",
 /*  83 */ "expr ::= expr lop expr",
 /*  84 */ "expr ::= expr ISDIVBY expr",
 /*  85 */ "expr ::= expr ISNOTDIVBY expr",
 /*  86 */ "expr ::= expr ISEVEN",
 /*  87 */ "expr ::= expr ISNOTEVEN",
 /*  88 */ "expr ::= expr ISEVENBY expr",
 /*  89 */ "expr ::= expr ISNOTEVENBY expr",
 /*  90 */ "expr ::= expr ISODD",
 /*  91 */ "expr ::= expr ISNOTODD",
 /*  92 */ "expr ::= expr ISODDBY expr",
 /*  93 */ "expr ::= expr ISNOTODDBY expr",
 /*  94 */ "expr ::= value INSTANCEOF ID",
 /*  95 */ "expr ::= value INSTANCEOF value",
 /*  96 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /*  97 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /*  98 */ "value ::= variable",
 /*  99 */ "value ::= UNIMATH value",
 /* 100 */ "value ::= NOT value",
 /* 101 */ "value ::= TYPECAST value",
 /* 102 */ "value ::= variable INCDEC",
 /* 103 */ "value ::= HEX",
 /* 104 */ "value ::= INTEGER",
 /* 105 */ "value ::= INTEGER DOT INTEGER",
 /* 106 */ "value ::= INTEGER DOT",
 /* 107 */ "value ::= DOT INTEGER",
 /* 108 */ "value ::= ID",
 /* 109 */ "value ::= function",
 /* 110 */ "value ::= OPENP expr CLOSEP",
 /* 111 */ "value ::= SINGLEQUOTESTRING",
 /* 112 */ "value ::= doublequoted_with_quotes",
 /* 113 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 114 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 115 */ "value ::= smartytag",
 /* 116 */ "variable ::= varindexed",
 /* 117 */ "variable ::= DOLLAR varvar AT ID",
 /* 118 */ "variable ::= object",
 /* 119 */ "variable ::= HATCH ID HATCH",
 /* 120 */ "variable ::= HATCH variable HATCH",
 /* 121 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 122 */ "arrayindex ::= arrayindex indexdef",
 /* 123 */ "arrayindex ::=",
 /* 124 */ "indexdef ::= DOT DOLLAR varvar",
 /* 125 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 126 */ "indexdef ::= DOT ID",
 /* 127 */ "indexdef ::= DOT INTEGER",
 /* 128 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 129 */ "indexdef ::= OPENB ID CLOSEB",
 /* 130 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 131 */ "indexdef ::= OPENB expr CLOSEB",
 /* 132 */ "indexdef ::= OPENB CLOSEB",
 /* 133 */ "varvar ::= varvarele",
 /* 134 */ "varvar ::= varvar varvarele",
 /* 135 */ "varvarele ::= ID",
 /* 136 */ "varvarele ::= LDEL expr RDEL",
 /* 137 */ "object ::= varindexed objectchain",
 /* 138 */ "objectchain ::= objectelement",
 /* 139 */ "objectchain ::= objectchain objectelement",
 /* 140 */ "objectelement ::= PTR ID arrayindex",
 /* 141 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 142 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 143 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 144 */ "objectelement ::= PTR method",
 /* 145 */ "function ::= ID OPENP params CLOSEP",
 /* 146 */ "method ::= ID OPENP params CLOSEP",
 /* 147 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 148 */ "params ::= expr COMMA params",
 /* 149 */ "params ::= expr",
 /* 150 */ "params ::=",
 /* 151 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 152 */ "modifierlist ::= modifier modparameters",
 /* 153 */ "modifier ::= VERT AT ID",
 /* 154 */ "modifier ::= VERT ID",
 /* 155 */ "modparameters ::= modparameters modparameter",
 /* 156 */ "modparameters ::=",
 /* 157 */ "modparameter ::= COLON value",
 /* 158 */ "modparameter ::= COLON array",
 /* 159 */ "static_class_access ::= method",
 /* 160 */ "static_class_access ::= method objectchain",
 /* 161 */ "static_class_access ::= ID",
 /* 162 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 163 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 164 */ "ifcond ::= EQUALS",
 /* 165 */ "ifcond ::= NOTEQUALS",
 /* 166 */ "ifcond ::= GREATERTHAN",
 /* 167 */ "ifcond ::= LESSTHAN",
 /* 168 */ "ifcond ::= GREATEREQUAL",
 /* 169 */ "ifcond ::= LESSEQUAL",
 /* 170 */ "ifcond ::= IDENTITY",
 /* 171 */ "ifcond ::= NONEIDENTITY",
 /* 172 */ "ifcond ::= MOD",
 /* 173 */ "lop ::= LAND",
 /* 174 */ "lop ::= LOR",
 /* 175 */ "lop ::= LXOR",
 /* 176 */ "array ::= OPENB arrayelements CLOSEB",
 /* 177 */ "arrayelements ::= arrayelement",
 /* 178 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 179 */ "arrayelements ::=",
 /* 180 */ "arrayelement ::= value APTR expr",
 /* 181 */ "arrayelement ::= ID APTR expr",
 /* 182 */ "arrayelement ::= expr",
 /* 183 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 184 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 185 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 186 */ "doublequoted ::= doublequotedcontent",
 /* 187 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 188 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 189 */ "doublequotedcontent ::= DOLLARID",
 /* 190 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 191 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 192 */ "doublequotedcontent ::= smartytag",
 /* 193 */ "doublequotedcontent ::= OTHER",
 /* 194 */ "optspace ::= SPACE",
 /* 195 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;
     
        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 84 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1694 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 79, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 1 ),
  array( 'lhs' => 80, 'rhs' => 2 ),
  array( 'lhs' => 80, 'rhs' => 0 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 81, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 3 ),
  array( 'lhs' => 84, 'rhs' => 2 ),
  array( 'lhs' => 84, 'rhs' => 0 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 6 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 13 ),
  array( 'lhs' => 96, 'rhs' => 2 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 7 ),
  array( 'lhs' => 82, 'rhs' => 9 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 8 ),
  array( 'lhs' => 82, 'rhs' => 11 ),
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 82, 'rhs' => 3 ),
  array( 'lhs' => 82, 'rhs' => 4 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 82, 'rhs' => 5 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 1 ),
  array( 'lhs' => 87, 'rhs' => 0 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 4 ),
  array( 'lhs' => 93, 'rhs' => 1 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 4 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 98, 'rhs' => 8 ),
  array( 'lhs' => 98, 'rhs' => 7 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 86, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 4 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 88, 'rhs' => 3 ),
  array( 'lhs' => 91, 'rhs' => 3 ),
  array( 'lhs' => 106, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 0 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 4 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 5 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 2 ),
  array( 'lhs' => 109, 'rhs' => 1 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 4 ),
  array( 'lhs' => 110, 'rhs' => 5 ),
  array( 'lhs' => 110, 'rhs' => 6 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 102, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 3 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 0 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 115, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 2 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 3 ),
  array( 'lhs' => 104, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 100, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 101, 'rhs' => 1 ),
  array( 'lhs' => 99, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 2 ),
  array( 'lhs' => 103, 'rhs' => 3 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 1 ),
  array( 'lhs' => 94, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        18 => 15,
        16 => 16,
        17 => 17,
        99 => 17,
        101 => 17,
        102 => 17,
        160 => 17,
        19 => 19,
        20 => 19,
        72 => 19,
        73 => 19,
        98 => 19,
        103 => 19,
        104 => 19,
        109 => 19,
        111 => 19,
        112 => 19,
        118 => 19,
        159 => 19,
        177 => 19,
        21 => 21,
        22 => 21,
        23 => 23,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 27,
        30 => 27,
        29 => 29,
        31 => 31,
        32 => 31,
        33 => 33,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        42 => 40,
        41 => 41,
        43 => 41,
        44 => 44,
        45 => 45,
        46 => 46,
        66 => 46,
        67 => 46,
        149 => 46,
        161 => 46,
        182 => 46,
        47 => 47,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        69 => 60,
        153 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        64 => 63,
        65 => 65,
        68 => 68,
        70 => 70,
        71 => 71,
        74 => 74,
        75 => 75,
        76 => 75,
        77 => 75,
        78 => 78,
        133 => 78,
        194 => 78,
        79 => 79,
        80 => 80,
        83 => 80,
        94 => 80,
        81 => 81,
        82 => 82,
        84 => 84,
        85 => 85,
        86 => 86,
        91 => 86,
        87 => 87,
        90 => 87,
        88 => 88,
        93 => 88,
        89 => 89,
        92 => 89,
        95 => 95,
        96 => 96,
        97 => 97,
        100 => 100,
        105 => 105,
        106 => 106,
        107 => 107,
        108 => 108,
        110 => 110,
        113 => 113,
        114 => 114,
        115 => 115,
        116 => 116,
        117 => 117,
        119 => 119,
        120 => 120,
        121 => 121,
        122 => 122,
        123 => 123,
        124 => 124,
        125 => 125,
        126 => 126,
        127 => 127,
        128 => 128,
        131 => 128,
        129 => 129,
        130 => 130,
        132 => 132,
        134 => 134,
        135 => 135,
        136 => 136,
        137 => 137,
        138 => 138,
        139 => 139,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        150 => 150,
        151 => 151,
        152 => 152,
        154 => 154,
        155 => 155,
        156 => 156,
        157 => 157,
        158 => 157,
        162 => 162,
        163 => 163,
        164 => 164,
        165 => 165,
        166 => 166,
        167 => 167,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        183 => 183,
        184 => 184,
        185 => 185,
        186 => 186,
        187 => 187,
        188 => 187,
        190 => 187,
        189 => 189,
        191 => 191,
        192 => 192,
        193 => 193,
        195 => 195,
    );
#line 95 "smarty_internal_templateparser.y"
    function yy_r0(){ $this->_retvalue = $this->root_buffer->to_smarty_php();     }
#line 2112 "smarty_internal_templateparser.php"
#line 101 "smarty_internal_templateparser.y"
    function yy_r1(){ $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);     }
#line 2115 "smarty_internal_templateparser.php"
#line 113 "smarty_internal_templateparser.y"
    function yy_r4(){
                                          if ($this->compiler->has_code) {
                                            $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
                                            $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
                                         } else { 
                                           $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
                                         }  
                                         $this->compiler->has_variable_string = false;
                                         $this->block_nesting_level = count($this->compiler->_tag_stack);
                                            }
#line 2127 "smarty_internal_templateparser.php"
#line 125 "smarty_internal_templateparser.y"
    function yy_r5(){ $this->_retvalue = new _smarty_tag($this, '');    }
#line 2130 "smarty_internal_templateparser.php"
#line 128 "smarty_internal_templateparser.y"
    function yy_r6(){ $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2133 "smarty_internal_templateparser.php"
#line 131 "smarty_internal_templateparser.y"
    function yy_r7(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2146 "smarty_internal_templateparser.php"
#line 143 "smarty_internal_templateparser.y"
    function yy_r8(){if ($this->is_xml) {
                                       $this->compiler->tag_nocache = true; 
                                       $this->is_xml = true; 
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>", $this->compiler, true));
                                      }elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                       $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                       $this->_retvalue = new _smarty_text($this, '');
                                      }
                                         }
#line 2162 "smarty_internal_templateparser.php"
#line 159 "smarty_internal_templateparser.y"
    function yy_r9(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
                                        }
                                      }
                                        }
#line 2183 "smarty_internal_templateparser.php"
#line 180 "smarty_internal_templateparser.y"
    function yy_r10(){
                                      if ($this->php_handling == Smarty::PHP_PASSTHRU) {
					                             $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                      } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
                                       $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
                                      }elseif ($this->php_handling == Smarty::PHP_ALLOW) {
                                        if ($this->asp_tags) {
                                          $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }elseif ($this->php_handling == Smarty::PHP_REMOVE) {
                                        if ($this->asp_tags) {
                                         $this->_retvalue = new _smarty_text($this, '');
                                        } else {
                                         $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
                                        }
                                      }
                                        }
#line 2204 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r11(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\$this->yystack[$this->yyidx + 0]->minor ]*[\r\n]+[\$this->yystack[$this->yyidx + 0]->minor ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));	
                                     }
                                        }
#line 2212 "smarty_internal_templateparser.php"
#line 208 "smarty_internal_templateparser.y"
    function yy_r12(){ $this->compiler->tag_nocache = true; $this->is_xml = true; $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));    }
#line 2215 "smarty_internal_templateparser.php"
#line 211 "smarty_internal_templateparser.y"
    function yy_r13(){if ($this->lex->strip) {
                                       $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));	
                                     } else {
                                       $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);	
                                     }
                                        }
#line 2223 "smarty_internal_templateparser.php"
#line 217 "smarty_internal_templateparser.y"
    function yy_r14(){
                                     $this->_retvalue = new _smarty_linebreak($this, $this->yystack[$this->yyidx + 0]->minor);
                                       }
#line 2228 "smarty_internal_templateparser.php"
#line 222 "smarty_internal_templateparser.y"
    function yy_r15(){ $this->_retvalue = '';     }
#line 2231 "smarty_internal_templateparser.php"
#line 223 "smarty_internal_templateparser.y"
    function yy_r16(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2234 "smarty_internal_templateparser.php"
#line 225 "smarty_internal_templateparser.y"
    function yy_r17(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2237 "smarty_internal_templateparser.php"
#line 228 "smarty_internal_templateparser.y"
    function yy_r19(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2240 "smarty_internal_templateparser.php"
#line 230 "smarty_internal_templateparser.y"
    function yy_r21(){ $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2243 "smarty_internal_templateparser.php"
#line 232 "smarty_internal_templateparser.y"
    function yy_r23(){ $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);     }
#line 2246 "smarty_internal_templateparser.php"
#line 233 "smarty_internal_templateparser.y"
    function yy_r24(){ $this->_retvalue = '<<?php ?>%';     }
#line 2249 "smarty_internal_templateparser.php"
#line 234 "smarty_internal_templateparser.y"
    function yy_r25(){ $this->_retvalue = '%<?php ?>>';     }
#line 2252 "smarty_internal_templateparser.php"
#line 242 "smarty_internal_templateparser.y"
    function yy_r26(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2255 "smarty_internal_templateparser.php"
#line 243 "smarty_internal_templateparser.y"
    function yy_r27(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2258 "smarty_internal_templateparser.php"
#line 245 "smarty_internal_templateparser.y"
    function yy_r29(){ $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2261 "smarty_internal_templateparser.php"
#line 253 "smarty_internal_templateparser.y"
    function yy_r31(){ $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));    }
#line 2264 "smarty_internal_templateparser.php"
#line 255 "smarty_internal_templateparser.y"
    function yy_r33(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));    }
#line 2267 "smarty_internal_templateparser.php"
#line 256 "smarty_internal_templateparser.y"
    function yy_r34(){ $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));    }
#line 2270 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r35(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);    }
#line 2273 "smarty_internal_templateparser.php"
#line 259 "smarty_internal_templateparser.y"
    function yy_r36(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());    }
#line 2276 "smarty_internal_templateparser.php"
#line 261 "smarty_internal_templateparser.y"
    function yy_r37(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2279 "smarty_internal_templateparser.php"
#line 263 "smarty_internal_templateparser.y"
    function yy_r38(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                     }
#line 2284 "smarty_internal_templateparser.php"
#line 267 "smarty_internal_templateparser.y"
    function yy_r39(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
                                                                                               $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                                }
#line 2289 "smarty_internal_templateparser.php"
#line 271 "smarty_internal_templateparser.y"
    function yy_r40(){ $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2292 "smarty_internal_templateparser.php"
#line 272 "smarty_internal_templateparser.y"
    function yy_r41(){ $tag = trim(substr($this->yystack[$this->yyidx + -4]->minor,$this->lex->ldel_length)); $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));    }
#line 2295 "smarty_internal_templateparser.php"
#line 276 "smarty_internal_templateparser.y"
    function yy_r44(){
                                                             $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);    }
#line 2299 "smarty_internal_templateparser.php"
#line 279 "smarty_internal_templateparser.y"
    function yy_r45(){ $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2302 "smarty_internal_templateparser.php"
#line 280 "smarty_internal_templateparser.y"
    function yy_r46(){ $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2305 "smarty_internal_templateparser.php"
#line 281 "smarty_internal_templateparser.y"
    function yy_r47(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2308 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r48(){ $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);    }
#line 2311 "smarty_internal_templateparser.php"
#line 284 "smarty_internal_templateparser.y"
    function yy_r49(){ $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2314 "smarty_internal_templateparser.php"
#line 286 "smarty_internal_templateparser.y"
    function yy_r50(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2318 "smarty_internal_templateparser.php"
#line 288 "smarty_internal_templateparser.y"
    function yy_r51(){
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2322 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r52(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));    }
#line 2326 "smarty_internal_templateparser.php"
#line 292 "smarty_internal_templateparser.y"
    function yy_r53(){ 
                                                            $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));    }
#line 2330 "smarty_internal_templateparser.php"
#line 296 "smarty_internal_templateparser.y"
    function yy_r54(){ $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);    }
#line 2333 "smarty_internal_templateparser.php"
#line 300 "smarty_internal_templateparser.y"
    function yy_r55(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());    }
#line 2336 "smarty_internal_templateparser.php"
#line 301 "smarty_internal_templateparser.y"
    function yy_r56(){ $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',$this->yystack[$this->yyidx + -1]->minor);    }
#line 2339 "smarty_internal_templateparser.php"
#line 302 "smarty_internal_templateparser.y"
    function yy_r57(){  $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
                                                                                         $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
                                                                                          }
#line 2344 "smarty_internal_templateparser.php"
#line 306 "smarty_internal_templateparser.y"
    function yy_r58(){  $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));    }
#line 2347 "smarty_internal_templateparser.php"
#line 312 "smarty_internal_templateparser.y"
    function yy_r59(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor; $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2350 "smarty_internal_templateparser.php"
#line 314 "smarty_internal_templateparser.y"
    function yy_r60(){ $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2353 "smarty_internal_templateparser.php"
#line 316 "smarty_internal_templateparser.y"
    function yy_r61(){ $this->_retvalue = array();    }
#line 2356 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r62(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
                                                 } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
                                                 } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
                                                 } else
                                                  $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");    }
#line 2366 "smarty_internal_templateparser.php"
#line 327 "smarty_internal_templateparser.y"
    function yy_r63(){ $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2369 "smarty_internal_templateparser.php"
#line 329 "smarty_internal_templateparser.y"
    function yy_r65(){ $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";    }
#line 2372 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r68(){$this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2375 "smarty_internal_templateparser.php"
#line 339 "smarty_internal_templateparser.y"
    function yy_r70(){ $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;    }
#line 2378 "smarty_internal_templateparser.php"
#line 341 "smarty_internal_templateparser.y"
    function yy_r71(){ $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2381 "smarty_internal_templateparser.php"
#line 352 "smarty_internal_templateparser.y"
    function yy_r74(){$this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';    }
#line 2384 "smarty_internal_templateparser.php"
#line 354 "smarty_internal_templateparser.y"
    function yy_r75(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;     }
#line 2387 "smarty_internal_templateparser.php"
#line 360 "smarty_internal_templateparser.y"
    function yy_r78(){$this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;    }
#line 2390 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r79(){  $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));     }
#line 2393 "smarty_internal_templateparser.php"
#line 367 "smarty_internal_templateparser.y"
    function yy_r80(){$this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2396 "smarty_internal_templateparser.php"
#line 368 "smarty_internal_templateparser.y"
    function yy_r81(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2399 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r82(){$this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2402 "smarty_internal_templateparser.php"
#line 371 "smarty_internal_templateparser.y"
    function yy_r84(){$this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2405 "smarty_internal_templateparser.php"
#line 372 "smarty_internal_templateparser.y"
    function yy_r85(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2408 "smarty_internal_templateparser.php"
#line 373 "smarty_internal_templateparser.y"
    function yy_r86(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2411 "smarty_internal_templateparser.php"
#line 374 "smarty_internal_templateparser.y"
    function yy_r87(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2414 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r88(){$this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2417 "smarty_internal_templateparser.php"
#line 376 "smarty_internal_templateparser.y"
    function yy_r89(){$this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';    }
#line 2420 "smarty_internal_templateparser.php"
#line 382 "smarty_internal_templateparser.y"
    function yy_r95(){$this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>'; $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;    }
#line 2423 "smarty_internal_templateparser.php"
#line 388 "smarty_internal_templateparser.y"
    function yy_r96(){ $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? $_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'\')->value : '.$this->yystack[$this->yyidx + 0]->minor;  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + -2]->minor', null, true, false)->nocache;    }
#line 2426 "smarty_internal_templateparser.php"
#line 389 "smarty_internal_templateparser.y"
    function yy_r97(){ $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2429 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r100(){ $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2432 "smarty_internal_templateparser.php"
#line 402 "smarty_internal_templateparser.y"
    function yy_r105(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2435 "smarty_internal_templateparser.php"
#line 403 "smarty_internal_templateparser.y"
    function yy_r106(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';     }
#line 2438 "smarty_internal_templateparser.php"
#line 404 "smarty_internal_templateparser.y"
    function yy_r107(){ $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2441 "smarty_internal_templateparser.php"
#line 406 "smarty_internal_templateparser.y"
    function yy_r108(){ if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'true';
                               } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'false';
                               } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
                                $this->_retvalue = 'null';
                               } else
                               $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";     }
#line 2451 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r110(){ $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";     }
#line 2454 "smarty_internal_templateparser.php"
#line 423 "smarty_internal_templateparser.y"
    function yy_r113(){if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
                      																				   if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
                                                                  $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
                      																				   } else {
                                                                  $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
                                                                 } 
                                                                } else {
                                                                 $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
                                                                }
                                                                   }
#line 2466 "smarty_internal_templateparser.php"
#line 433 "smarty_internal_templateparser.y"
    function yy_r114(){ if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2470 "smarty_internal_templateparser.php"
#line 436 "smarty_internal_templateparser.y"
    function yy_r115(){ $this->prefix_number++; $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>'; $this->_retvalue = '$_tmp'.$this->prefix_number;     }
#line 2473 "smarty_internal_templateparser.php"
#line 445 "smarty_internal_templateparser.y"
    function yy_r116(){if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
                                      } else {
                                      if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + 0]->minor['var']])) {
                                          $this->_retvalue = '(isset($_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'].') ? $_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + 0]->minor['var'] .']->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'].' : null)';
                                       } else {
                                         if (isset($this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'])) {
                                            $this->_retvalue = '(isset($_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'].') ? $_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'].' : null)';
                                         } else {
                                            $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor['var'] .')->value'.$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
                                         }
                                       }
                                       $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2487 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r117(){if (isset($this->compiler->local_var[$this->yystack[$this->yyidx + -2]->minor])) {
                                                  $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 } else {
                                                  $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor;
                                                 }
                                                  $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2495 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r119(){$this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';    }
#line 2498 "smarty_internal_templateparser.php"
#line 468 "smarty_internal_templateparser.y"
    function yy_r120(){$this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';    }
#line 2501 "smarty_internal_templateparser.php"
#line 471 "smarty_internal_templateparser.y"
    function yy_r121(){$this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);    }
#line 2504 "smarty_internal_templateparser.php"
#line 477 "smarty_internal_templateparser.y"
    function yy_r122(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2507 "smarty_internal_templateparser.php"
#line 479 "smarty_internal_templateparser.y"
    function yy_r123(){return;    }
#line 2510 "smarty_internal_templateparser.php"
#line 483 "smarty_internal_templateparser.y"
    function yy_r124(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + 0]->minor .')->value]'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable('$this->yystack[$this->yyidx + 0]->minor', null, true, false)->nocache;    }
#line 2513 "smarty_internal_templateparser.php"
#line 484 "smarty_internal_templateparser.y"
    function yy_r125(){ $this->_retvalue = '[$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -2]->minor .')->'.$this->yystack[$this->yyidx + 0]->minor.']'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -2]->minor,"'"), null, true, false)->nocache;    }
#line 2516 "smarty_internal_templateparser.php"
#line 485 "smarty_internal_templateparser.y"
    function yy_r126(){ $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";    }
#line 2519 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r127(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";    }
#line 2522 "smarty_internal_templateparser.php"
#line 487 "smarty_internal_templateparser.y"
    function yy_r128(){ $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";    }
#line 2525 "smarty_internal_templateparser.php"
#line 489 "smarty_internal_templateparser.y"
    function yy_r129(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';    }
#line 2528 "smarty_internal_templateparser.php"
#line 490 "smarty_internal_templateparser.y"
    function yy_r130(){ $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';    }
#line 2531 "smarty_internal_templateparser.php"
#line 494 "smarty_internal_templateparser.y"
    function yy_r132(){$this->_retvalue = '[]';    }
#line 2534 "smarty_internal_templateparser.php"
#line 502 "smarty_internal_templateparser.y"
    function yy_r134(){$this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2537 "smarty_internal_templateparser.php"
#line 504 "smarty_internal_templateparser.y"
    function yy_r135(){$this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';    }
#line 2540 "smarty_internal_templateparser.php"
#line 506 "smarty_internal_templateparser.y"
    function yy_r136(){$this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2543 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r137(){ if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') { $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;} else {
                                                         $this->_retvalue = '$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor['var'] .')->value'.$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor['var'],"'"), null, true, false)->nocache;}    }
#line 2547 "smarty_internal_templateparser.php"
#line 514 "smarty_internal_templateparser.y"
    function yy_r138(){$this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;     }
#line 2550 "smarty_internal_templateparser.php"
#line 516 "smarty_internal_templateparser.y"
    function yy_r139(){$this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2553 "smarty_internal_templateparser.php"
#line 518 "smarty_internal_templateparser.y"
    function yy_r140(){if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									   }
                                                     $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
                                                         }
#line 2560 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r141(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															 }
                                                               $this->_retvalue = '->{$_smarty_tpl->getVariable('. $this->yystack[$this->yyidx + -1]->minor .')->value'.$this->yystack[$this->yyidx + 0]->minor.'}'; $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable(trim($this->yystack[$this->yyidx + -1]->minor,"'"), null, true, false)->nocache;
                                                                   }
#line 2567 "smarty_internal_templateparser.php"
#line 528 "smarty_internal_templateparser.y"
    function yy_r142(){if ($this->security) {
                                                                 $this->compiler->trigger_template_error (self::Err2);
																															   }
                     																						 $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                     																						    }
#line 2574 "smarty_internal_templateparser.php"
#line 533 "smarty_internal_templateparser.y"
    function yy_r143(){if ($this->security) {
                                                                         $this->compiler->trigger_template_error (self::Err2);
																															         }
                                                                       $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
                                                                          }
#line 2581 "smarty_internal_templateparser.php"
#line 539 "smarty_internal_templateparser.y"
    function yy_r144(){ $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2584 "smarty_internal_templateparser.php"
#line 545 "smarty_internal_templateparser.y"
    function yy_r145(){if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
																					            if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
																					                if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0) {
																					                  $this->_retvalue = '('. $this->yystack[$this->yyidx + -1]->minor .' !== null)';
																					                } elseif (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0){
																					                   $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + -1]->minor.';?>';
																					                  $this->_retvalue = 'empty($_tmp'.$this->prefix_number.')';
																					                } else {
																					                  $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
																					                }
																					            } else {
                                                       $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
                                                      }
                                                    }    }
#line 2600 "smarty_internal_templateparser.php"
#line 563 "smarty_internal_templateparser.y"
    function yy_r146(){if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
                                                      $this->compiler->trigger_template_error (self::Err1);
																									 }
                                                   $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $this->yystack[$this->yyidx + -1]->minor .")";
                                                      }
#line 2607 "smarty_internal_templateparser.php"
#line 568 "smarty_internal_templateparser.y"
    function yy_r147(){if ($this->security) {
                                                              $this->compiler->trigger_template_error (self::Err2);
																													 }
                                                           $this->prefix_number++; $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'=$_smarty_tpl->getVariable(\''. $this->yystack[$this->yyidx + -3]->minor .'\')->value;?>'; $this->_retvalue = '$_tmp'.$this->prefix_number.'('. $this->yystack[$this->yyidx + -1]->minor .')';
                                                              }
#line 2614 "smarty_internal_templateparser.php"
#line 576 "smarty_internal_templateparser.y"
    function yy_r148(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.",".$this->yystack[$this->yyidx + 0]->minor;    }
#line 2617 "smarty_internal_templateparser.php"
#line 580 "smarty_internal_templateparser.y"
    function yy_r150(){ return;    }
#line 2620 "smarty_internal_templateparser.php"
#line 585 "smarty_internal_templateparser.y"
    function yy_r151(){$this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));    }
#line 2623 "smarty_internal_templateparser.php"
#line 586 "smarty_internal_templateparser.y"
    function yy_r152(){$this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));    }
#line 2626 "smarty_internal_templateparser.php"
#line 589 "smarty_internal_templateparser.y"
    function yy_r154(){ $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2629 "smarty_internal_templateparser.php"
#line 594 "smarty_internal_templateparser.y"
    function yy_r155(){ $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);    }
#line 2632 "smarty_internal_templateparser.php"
#line 596 "smarty_internal_templateparser.y"
    function yy_r156(){$this->_retvalue = array();    }
#line 2635 "smarty_internal_templateparser.php"
#line 598 "smarty_internal_templateparser.y"
    function yy_r157(){$this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);    }
#line 2638 "smarty_internal_templateparser.php"
#line 608 "smarty_internal_templateparser.y"
    function yy_r162(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2641 "smarty_internal_templateparser.php"
#line 610 "smarty_internal_templateparser.y"
    function yy_r163(){ $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2644 "smarty_internal_templateparser.php"
#line 619 "smarty_internal_templateparser.y"
    function yy_r164(){$this->_retvalue = '==';    }
#line 2647 "smarty_internal_templateparser.php"
#line 620 "smarty_internal_templateparser.y"
    function yy_r165(){$this->_retvalue = '!=';    }
#line 2650 "smarty_internal_templateparser.php"
#line 621 "smarty_internal_templateparser.y"
    function yy_r166(){$this->_retvalue = '>';    }
#line 2653 "smarty_internal_templateparser.php"
#line 622 "smarty_internal_templateparser.y"
    function yy_r167(){$this->_retvalue = '<';    }
#line 2656 "smarty_internal_templateparser.php"
#line 623 "smarty_internal_templateparser.y"
    function yy_r168(){$this->_retvalue = '>=';    }
#line 2659 "smarty_internal_templateparser.php"
#line 624 "smarty_internal_templateparser.y"
    function yy_r169(){$this->_retvalue = '<=';    }
#line 2662 "smarty_internal_templateparser.php"
#line 625 "smarty_internal_templateparser.y"
    function yy_r170(){$this->_retvalue = '===';    }
#line 2665 "smarty_internal_templateparser.php"
#line 626 "smarty_internal_templateparser.y"
    function yy_r171(){$this->_retvalue = '!==';    }
#line 2668 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r172(){$this->_retvalue = '%';    }
#line 2671 "smarty_internal_templateparser.php"
#line 629 "smarty_internal_templateparser.y"
    function yy_r173(){$this->_retvalue = '&&';    }
#line 2674 "smarty_internal_templateparser.php"
#line 630 "smarty_internal_templateparser.y"
    function yy_r174(){$this->_retvalue = '||';    }
#line 2677 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r175(){$this->_retvalue = ' XOR ';    }
#line 2680 "smarty_internal_templateparser.php"
#line 636 "smarty_internal_templateparser.y"
    function yy_r176(){ $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';    }
#line 2683 "smarty_internal_templateparser.php"
#line 638 "smarty_internal_templateparser.y"
    function yy_r178(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;     }
#line 2686 "smarty_internal_templateparser.php"
#line 639 "smarty_internal_templateparser.y"
    function yy_r179(){ return;     }
#line 2689 "smarty_internal_templateparser.php"
#line 640 "smarty_internal_templateparser.y"
    function yy_r180(){ $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2692 "smarty_internal_templateparser.php"
#line 641 "smarty_internal_templateparser.y"
    function yy_r181(){ $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;    }
#line 2695 "smarty_internal_templateparser.php"
#line 648 "smarty_internal_templateparser.y"
    function yy_r183(){ $this->_retvalue = "''";     }
#line 2698 "smarty_internal_templateparser.php"
#line 649 "smarty_internal_templateparser.y"
    function yy_r184(){ $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();     }
#line 2701 "smarty_internal_templateparser.php"
#line 651 "smarty_internal_templateparser.y"
    function yy_r185(){ $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor); $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;     }
#line 2704 "smarty_internal_templateparser.php"
#line 652 "smarty_internal_templateparser.y"
    function yy_r186(){ $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2707 "smarty_internal_templateparser.php"
#line 654 "smarty_internal_templateparser.y"
    function yy_r187(){ $this->_retvalue = new _smarty_code($this, $this->yystack[$this->yyidx + -1]->minor);     }
#line 2710 "smarty_internal_templateparser.php"
#line 656 "smarty_internal_templateparser.y"
    function yy_r189(){if (isset($this->compiler->local_var["'".substr($this->yystack[$this->yyidx + 0]->minor,1)."'"])) {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
                                                      } else {
                                                       $this->_retvalue = new _smarty_code($this, '$_smarty_tpl->getVariable(\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\')->value');
                                                      }
                                                      $this->compiler->tag_nocache = $this->compiler->tag_nocache | $this->template->getVariable(trim($this->yystack[$this->yyidx + 0]->minor,"'"), null, true, false)->nocache;
      }
#line 2719 "smarty_internal_templateparser.php"
#line 664 "smarty_internal_templateparser.y"
    function yy_r191(){ $this->_retvalue = new _smarty_code($this, '('.$this->yystack[$this->yyidx + -1]->minor.')');     }
#line 2722 "smarty_internal_templateparser.php"
#line 665 "smarty_internal_templateparser.y"
    function yy_r192(){
   $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
      }
#line 2727 "smarty_internal_templateparser.php"
#line 668 "smarty_internal_templateparser.y"
    function yy_r193(){ $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);     }
#line 2730 "smarty_internal_templateparser.php"
#line 675 "smarty_internal_templateparser.y"
    function yy_r195(){$this->_retvalue = '';    }
#line 2733 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0 
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 77 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 2796 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 69 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 2814 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */
        
        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);
        
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }
        
        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }            
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>